<?php

namespace Tests\Feature;

use App\Enums\TipoPessoaTomador;
use App\Models\AtividadeEconomica;
use App\Models\DadosCadastrais;
use App\Models\Prestador;
use App\Models\PrestadorNotaFiscal;
use App\Models\Tomador;
use App\Models\TomadorNotaFiscal;
use App\Services\AtividadeEconomica\CriaAtividadeEconomica;
use App\Services\DadosCadastrais\CriaDadosCadastrais;
use App\Services\Prestador\CriaPrestador;
use App\Services\Prestador\CriaPrestadorNotaFiscal;
use App\Services\Tomador\CriaTomador;
use App\Services\Tomador\CriaTomadorNotaFiscal;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ConjuntoDeDadosPreCadastradosTest extends TestCase
{
    use RefreshDatabase;

    public function test_criacao_de_dados_pre_cadastrados()
    {
        /**
         * Dados Cadastrais
         */
        $criadorDeDadosCadastrais = new CriaDadosCadastrais(
            '52001238000135',
            'PRESTADOR TESTE WEBSERVICE',
            '16.139.962-3',
            '0020222',
            1058,
            '58900971',
            '',
            'Centro',
            'Rua do Comércio',
            's/n',
            '',
            'testewebservice@test.com',
            '(83) 98877-6655',
            '',
            TipoPessoaTomador::PESSOA_JURIDICA,
            'Manoel Proprietário',
            1290,
        );

        $dadosCadastraisSalvos = $criadorDeDadosCadastrais->criar();

        /**
         * Prestador
         */
        $criadorDePrestador = new CriaPrestador(
            '3232126546466',
            'REPRESENTANTE TESTE',
            '26105065035',
            $dadosCadastraisSalvos->id
        );

        $prestadorCriado = $criadorDePrestador->criar();

        /**
         * Prestador Nota Fiscal
         */
        $criadorDePrestadoresNota = new CriaPrestadorNotaFiscal(
            $dadosCadastraisSalvos->razao_nome,
            $dadosCadastraisSalvos->cep,
            'Cajazeiras/PARAÍBA', /** Buscar a cidade dinâmicamente quando em prod. */
            $dadosCadastraisSalvos->bairro,
            $dadosCadastraisSalvos->rua,
            '3232113',
            '',
            $dadosCadastraisSalvos->email,
            $dadosCadastraisSalvos->telefone,
            '25',
            TipoPessoaTomador::PESSOA_JURIDICA
        );

        $prestadorNotaCriado = $criadorDePrestadoresNota->criar();

        /**
         * Atividade Econômica
         */
        $criadorDeAtividadeEconomica = new CriaAtividadeEconomica(
            1,
            $prestadorCriado->id,
            348,
            664,
            1
        );

        $atividadeEconomicaCriada = $criadorDeAtividadeEconomica->criar();

        /**
         * Tomador
         */
        $criadorDeTomadores = new CriaTomador(
            $dadosCadastraisSalvos->id,
            $prestadorCriado->id,
            40 /** cajazeiras */
        );

        $tomadorCriado = $criadorDeTomadores->criar();

        /**
         * Tomador Nota Fiscal
         */
        $criadorDeTomadorNota = new CriaTomadorNotaFiscal(
            $dadosCadastraisSalvos->razao_nome,
            '82779205040',
            '58900970',
            'Centro',
            'Rua Coronel Juvêncio Carneiro',
            '489',
            '',
            'tomador@teste.com',
            '(83) 3333-4444',
            '',
            $dadosCadastraisSalvos->inscricao_estadual,
            $dadosCadastraisSalvos->inscricao_municipal,
            '',
            TipoPessoaTomador::PESSOA_JURIDICA,
            1058,
            1290
        );

        $tomadorNota = $criadorDeTomadorNota->criar();

        $this->assertInstanceOf(DadosCadastrais::class, $dadosCadastraisSalvos);
        $this->assertDatabaseHas('dados_cadastrais', ['cnpj_cpf' => '52001238000135']);

        $this->assertInstanceOf(Prestador::class, $prestadorCriado);
        $this->assertDatabaseHas('prestador', ['cpf_representante' => '26105065035']);

        $this->assertInstanceOf(AtividadeEconomica::class, $atividadeEconomicaCriada);
        $this->assertDatabaseHas('atividade_economica', ['id_prestador' => $prestadorCriado->id]);
        $this->assertDatabaseHas('atividade_economica', ['id_atividade_economica_classe' => 348]);

        $this->assertInstanceOf(Tomador::class, $tomadorCriado);
        $this->assertDatabaseHas('tomador', ['id_dados_cadastrais' => $dadosCadastraisSalvos->id]);

        $this->assertInstanceOf(TomadorNotaFiscal::class, $tomadorNota);
        $this->assertDatabaseHas('tomador_nota_fiscal', ['email_tomador' => 'tomador@teste.com']);

        $this->assertInstanceOf(PrestadorNotaFiscal::class, $prestadorNotaCriado);
        $this->assertDatabaseHas('prestador_nota_fiscal', ['numero_prestador' => '3232113']);
        $this->assertDatabaseHas('prestador_nota_fiscal', ['email_prestador' => $dadosCadastraisSalvos->email]);
    }
}
