<?php

namespace Tests\Feature;

use App\Enums\TipoPessoaTomador;
use App\Models\AtividadeEconomica;
use App\Models\AtividadeEconomicaClasse;
use App\Models\AtividadeEconomicaSubClasse;
use App\Models\Cidade;
use App\Models\DadosCadastrais;
use App\Models\Prestador;
use App\Services\AtividadeEconomica\BuscaAtividadeEconomica;
use App\Services\AtividadeEconomica\CriaAtividadeEconomica;
use App\Services\DadosCadastrais\CriaDadosCadastrais;
use App\Services\Prestador\CriaPrestador;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;

class AtividadeEconomicaTest extends TestCase
{
    use RefreshDatabase;

    private AtividadeEconomica $atividadeEconomicaCriada;
    private DadosCadastrais $dadosCadastraisSalvos;
    private Prestador $prestadorCriado;
    private Cidade $cidade;
    private AtividadeEconomicaClasse $atividadeClasse;
    private AtividadeEconomicaSubClasse $atividadeSubClasse;

    public function test_instanciacao_dos_objetos()
    {
        $this->assertInstanceOf(Cidade::class, $this->cidade);
        $this->assertInstanceOf(DadosCadastrais::class, $this->dadosCadastraisSalvos);
        $this->assertInstanceOf(Prestador::class, $this->prestadorCriado);
        $this->assertInstanceOf(AtividadeEconomica::class, $this->atividadeEconomicaCriada);
        $this->assertInstanceOf(AtividadeEconomicaClasse::class, $this->atividadeClasse);
        $this->assertInstanceOf(AtividadeEconomicaSubClasse::class, $this->atividadeSubClasse);
    }

    public function test_buscar_atividade_economica()
    {
        $atividade = BuscaAtividadeEconomica::buscar('4520001', $this->prestadorCriado->id);

        $this->assertInstanceOf(AtividadeEconomica::class, $atividade);
        $this->assertEquals(1, $this->atividadeSubClasse->id);
        $this->assertEquals('45', $this->atividadeClasse->divisao);
    }

    protected function setUp(): void
    {
        parent::setUp();

        $this->cidade = Cidade::create([
            'nome' => 'PORTO VELHO',
            'codigo' => '1100205',
            'id_estado' => 1
        ]);

        $criadorDeDadosCadastrais = new CriaDadosCadastrais(
            '123',
            'PRESTADOR TESTE WEBSERVICE',
            '16.139.962-3',
            '0020222',
            1058,
            '58900971',
            '',
            'Centro',
            'Rua do Comércio',
            's/n',
            '',
            'testewebservice@test.com',
            '(83) 98877-6655',
            '',
            TipoPessoaTomador::PESSOA_JURIDICA,
            'Manoel Proprietário',
            $this->cidade->id,
        );

        $this->dadosCadastraisSalvos = $criadorDeDadosCadastrais->criar();

        $criadorDePrestador = new CriaPrestador(
            '3232126546466',
            'REPRESENTANTE TESTE',
            '456',
            $this->dadosCadastraisSalvos->id
        );

        $this->prestadorCriado = $criadorDePrestador->criar();

        $this->atividadeClasse = AtividadeEconomicaClasse::create([
            'codigo' => '45.20-0',
            'descricao' => 'Manutenção e reparação de veículos automotores',
            'secao' => 'G',
            'divisao' => '45',
            'codigo_grupo' => '45.2',
            'id_grupo' => 1,
        ]);

        $this->atividadeSubClasse = AtividadeEconomicaSubClasse::create([
            'subclasse' => '4520-0/01',
            'nome_subclasse' => 'Serviços de manutenção e reparação mecânica de veículos automotores',
            'classe' => '45.20-0',
            'nome_classe' => 'Manutenção e reparação de veículos automotores',
            'grupo' => '45.2',
            'nome_grupo' => 'Manutenção e reparação de veículos automotores',
            'divisao' => '45',
            'nome_divisao' => 'COMÉRCIO E REPARAÇÃO DE VEÍCULOS AUTOMOTORES E MOTOCICLETAS'
        ]);

        $criadorDeAtividadeEconomica = new CriaAtividadeEconomica(
            1,
            $this->prestadorCriado->id,
            $this->atividadeClasse->id,
            $this->atividadeSubClasse->id,
            1
        );

        $this->atividadeEconomicaCriada = $criadorDeAtividadeEconomica->criar();
    }
}
