<div>
    <div wire:ignore.self class="modal fade" id="uploadCsvBalanceteModal" tabindex="-1" aria-labelledby="uploadCsvBalanceteModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <form wire:submit.prevent="submit">
                <div class="modal-content">

                    <div class="modal-header">
                        <h5 class="modal-title" id="uploadCsvBalanceteModalLabel">
                            <span class='mdi mdi-checkbox-marked-circle-outline'></span> Enviar Arquivo
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body bg-light">

                        <div class="container">

                            <x-alerts :alert="$alert" />

                            @if($showForm)

                                <h4 class="text-primary"><strong>Competência {{ $competencia_para_modal }}</strong></h4>

                                <hr>

                                <h5><strong>Orientações:</strong></h5>
                                <ul>
                                    <li>O arquivo deve ter extensão do tipo .xls ou .csv</li>
                                    <li>O arquivo deve está formatado de acordo com o padrão estabelecido <a href="#">(detalhes sobre o padrão)</a></li>
                                </ul>

                                @if($mensagem_fora_de_prazo_modal)
                                    <div class="alert alert-warning">
                                        {!! $mensagem_fora_de_prazo_modal !!}
                                    </div>
                                @endif

                                <div class="form-group">
                                    <label for="arquivo_csv"  class="form-label mt-4"><strong>Selecione um arquivo do tipo csv ou xls:</strong> <span class="text-danger">*</span></label>
                                    <input class="form-control @error('arquivo_csv') is-invalid @enderror" id="arquivo_csv" type="file" wire:model="arquivo_csv" />
                                    @error('arquivo_csv')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            @endif

                        </div> <!-- /container form -->

                    </div> <!-- /modal-body -->

                    @if($showForm)

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:loading.remove>
                                <i class="mdi mdi-close"></i> Fechar
                            </button>
                            <button type="submit" class="btn btn-primary" wire:target="submit" wire:loading.remove>
                                <i class="mdi mdi-check"></i> Enviar Arquivo
                            </button>
                            <button type="button" class="btn btn-primary disabled" wire:target="submit" wire:loading>
                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                Aguarde, estamos processando a sua requisição...
                            </button>
                        </div>
                    @endif

                </div> <!-- /modal-content -->
            </form>
        </div> <!-- modal-dialog -->
    </div><!-- /card -->
</div>
