<div class="row mb-3">
    <small class="text-danger">* Campos obrigatórios.</small>
</div>

<div class="row">
    <div class="col-3 text-end">
        <label for="instituicao_financeira_id" class="pt-2"><strong>Instituição:</strong> <span class="text-danger">*</span></label>
    </div>
    <div class="col-7">
        <select id="instituicao_financeira_id"
                class="form-select @error('instituicao_financeira_id') is-invalid @enderror"
                wire:model.defer="instituicao_financeira_id"
        >
            @foreach($instituicoesFinanceiras as $instituicao_financeira)
                <option value="{{ $instituicao_financeira->id }}">{{ $instituicao_financeira->nome }} (Cód.: {{ $instituicao_financeira->codigo }}) </option>>
            @endforeach
        </select>
        @error('instituicao_financeira_id') <div class="invalid-feedback">{{ $message }}</div>@enderror
    </div>
</div>


<hr style="border-top: 2px solid #999; margin-bottom:20px;">

<div class="form-floating mb-3">
    <input class="form-control @error('nome') is-invalid @enderror" id="nome" type="text" placeholder="Nome" wire:model="nome" />
    <label for="nome"><strong>Nome:</strong> <span class="text-danger">*</span></label>
    @error('nome')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="form-floating mb-3">
    <input class="form-control @error('codigo') is-invalid @enderror" id="codigo" type="text" placeholder="Código" wire:model="codigo" />
    <label for="codigo"><strong>Código:</strong> <span class="text-danger">*</span></label>
    @error('codigo')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="form-floating mb-3">
    <input class="form-control cnpj @error('cnpj') is-invalid @enderror" id="cnpj" type="text" placeholder="CNPJ" wire:model="cnpj" />
    <label for="cnpj"><strong>CNPJ:</strong> <span class="text-danger">*</span></label>
    @error('cnpj')<div class="invalid-feedback">{{ $message }}</div>@enderror
</div>

<div class="form-floating mb-3">
    <input class="form-control" id="observacoes" type="text" placeholder="Observações" wire:model="observacoes" />
    <label for="observacoes"><strong>Observações:</strong>   </label>
</div>

@isset($status)
    <div class="form-floating mb-3">
        <select class="form-select @error('status') is-invalid @enderror" id="status" wire:model="status">
            <option>-- Selecione --</option>
            @foreach($statusAgecias as $key => $value)
                <option value="{{ $key }}">{{ $value }} </option>
            @endforeach
        </select>
        <label for="status">Situação (Status)</label>
        @error('status') <div class="invalid-feedback">{{ $message }}</div>@enderror
    </div>
@endisset
