<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('pageTitle', "Admin Dashboard")</title>

    <link rel="stylesheet" href="{{ asset('admin/css/bootstrap.css') }}">

    <link rel="stylesheet" href="{{ asset('admin/vendors/simple-datatables/style.css') }}">
    <link rel="stylesheet" href="{{ asset('admin/vendors/perfect-scrollbar/perfect-scrollbar.css') }}">
    <link rel="stylesheet" href="{{ asset('admin/css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('admin/vendors/chartjs/Chart.min.css') }}">
    <link rel="stylesheet" href="{{ mix('admin/css/custom-dashboard.css') }}">

    @yield('styles')

    <link rel="shortcut icon" href="{{ asset('images/favicon.ico') }}" type="image/x-icon">
</head>
<body>
<div id="app">

    @include('sweetalert::alert')

    @include('layouts.admin._includes._sidebar')
    <div id="main">
        @include('layouts.admin._includes._navbar')
        <div class="main-content container-fluid">
            <div class="page-title">
                <h3>@yield('pageTitle', "")</h3>
                <p class="text-subtitle text-muted">@yield('pageSubTitle', "") </p>
            </div>

            @yield('conteudo')

            @include('layouts.admin._includes._footer')

        </div><!-- /main-conttent -->
    </div><!-- /main -->
</div><!-- /app -->

{{--<script src="{{ asset('admin/vendors/chartjs/Chart.min.js') }}"></script>--}}
{{--<script src="{{ asset('admin/vendors/apexcharts/apexcharts.min.js') }}"></script>--}}
{{--<script src="{{ asset('admin/js/custom-dashboard.js') }}"></script>--}}

<script src="{{ asset('admin/js/feather-icons/feather.min.js') }}"></script>
<script src="{{ asset('admin/vendors/perfect-scrollbar/perfect-scrollbar.min.js') }}"></script>
<script src="{{ asset('admin/js/app.js') }}"></script>

<script src="{{ asset('admin/vendors/simple-datatables/simple-datatables.js') }}"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.9.5/tinymce.min.js" referrerpolicy="origin"></script>



@yield('scripts')

<script src="{{ asset('admin/js/main.js') }}"></script>

</body>

</html>
