<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePrestadorsTable extends Migration
{
    public function up()
    {
        Schema::create('prestador', function (Blueprint $table) {
            $table->id();
            $table->string('assinatura_digital', 100)->nullable();
            $table->string('nome_representante')->nullable();
            $table->string('cpf_representante', 14)->nullable();

            $table->unsignedBigInteger('id_dados_cadastrais')->nullable();
            $table->foreign('id_dados_cadastrais')
                ->references('id')->on('dados_cadastrais')
                ->onDelete('cascade');

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('prestador');
    }
}
