<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('data_limte_envio_financeiros', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid');
            $table->string('competencia'); // 2023.1, 2023.2
            $table->string('dia_limite_envio');
            $table->decimal('valor_multa', 10,2)->nullable();
            $table->tinyInteger('status')->unsigned()->default(StatusEnum::CANCELADO);

            $table->foreignId('instituicao_id')->nullable()->constrained('instituicao');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('data_limte_envio_financeiros');
    }
};
