<?php

namespace App\View\Components;

use App\Enums\StatusPadraoEnum;
use App\Validadores\LoteRps\UsuarioPrestadorInvalido;
use Illuminate\View\Component;

class StatusPadrao extends Component
{
    public $color = 'success';
    public $role = StatusPadraoEnum::ATIVO;

    public function __construct($status)
    {
        if (StatusPadraoEnum::INATIVO === (int) $status) {
            $this->color = 'danger';
            $this->role = StatusPadraoEnum::INATIVO;
        }
    }

    public function render()
    {
        return view('components.status-padrao');
    }
}
