<?php

namespace App\Validadores\LoteRps;

use App\Enums\SituacaoUsuarioEnum;
use App\Models\DadosCadastrais;
use App\Models\Lote;
use App\Models\Prestador;
use App\Models\Usuario;
use App\Services\Prestador\BuscaPrestador;
use Exception;

class UsuarioPrestadorInvalido extends AbstractLoteRpsValidator
{

    /**
     * Virifica se o prestador possui um usuário inativo no sistema.
     *
     * @throws Exception
     */
    public function validar(Lote $lote)
    {
        $prestador = BuscaPrestador::buscar($lote, null);

        $usuario = Usuario::where('id', $prestador->id_usuario)->first();

        if ($usuario->situacao === SituacaoUsuarioEnum::INATIVO)
            throw new Exception("O Usuário para o Prestador informado encontra-se inativo no sistema.");

        return $this->proximoLote->validar($lote);
    }
}
