<?php

namespace App\Validadores\LoteRps;

use App\Models\DadosCadastrais;
use App\Models\Lote;
use Exception;

class InscricaoMunicipalContribuinteInvalida extends AbstractLoteRpsValidator
{

    /**
     * @throws Exception
     */
    public function validar(Lote $lote)
    {
        $inscricaoValida = $this->inscricaoValida($lote->inscricaoMunicipal, $lote->cnpj);

        if (!$inscricaoValida)
            throw new Exception("COD: 103 - A Inscrição Municipal {$lote->inscricaoMunicipal} não é válida: Informe a Inscrição Municipal do contribuinte.");

        $this->proximoLote->validar($lote);
    }

    private function inscricaoValida(string $inscricao, string $cnpj_cpf)
    {
        return DadosCadastrais::where('inscricao_municipal', '=', $inscricao)
            ->where('cnpj_cpf', $cnpj_cpf)
            ->first();
    }
}
