<?php

namespace App\Services\Xml;

use App\Traits\AjustadorDeDataHotaPtBr;
use Carbon\Carbon;

class XmlRetorno
{
    use AjustadorDeDataHotaPtBr;

    private $dataDeRecebimento = null;

    public function __construct()
    {
        $this->setLocate();
        $this->dataDeRecebimento = Carbon::now()->format('d/m/Y H:i:s');
    }

    /**
     * Responsável pelo formatação das mensagens de sucesso em xml, que serão retornadas ao usuário.
     * @param string $cnpj
     * @param string $numeroDolote
     * @param array $notas
     * @return string
     */
    public function sucesso(string $cnpj, string $numeroDolote, array $notas) : string
    {
        $dom = new \DOMDocument('1.0', 'UTF-8');

        $mensagemValue = $dom->createTextNode("Importacao realizada com sucesso e notas geradas ({$cnpj}, Lote = {$numeroDolote}, Data: {$this->dataDeRecebimento}");
        $mensagemNode = $dom->createElement('mensagem');
        $mensagemNode->appendChild($mensagemValue);

        if (count($notas) > 1) {
            $retornoNode = $this->criarNodesParaVariasNotas($dom, $notas, $mensagemNode);
        } else {
            $retornoNode = $this->criarNodeParaUmaUnicaNota($dom, $notas, $mensagemNode);
        }

        $dom->appendChild($retornoNode);

        return $dom->saveXML();
    }

    /**
     * Responsável pelo formatação das mensagens de erro em xml, que serão retornadas ao usuário.
     * @param array $erros
     * @return false|string
     */
    public function errorsArrayToXml(array $erros)
    {
        $dom = new \DOMDocument('1.0', 'UTF-8');

        $errosNode = $dom->createElement('erros');

        foreach ($erros as $key => $erro) {

            $mensagemDeErroValue = $dom->createTextNode($erro[0]);
            $mensagemDeErroNode = $dom->createElement("mensagemDeErro");
            $mensagemDeErroNode->appendChild($mensagemDeErroValue);
            $erroNode = $dom->createElement('erro');
            $erroNode->appendChild($mensagemDeErroNode);
            $errosNode->appendChild($erroNode);
        }

        $retornoNode = $dom->createElement('retorno');
        $retornoNode->appendChild($errosNode);

        $dom->appendChild($retornoNode);

        return $dom->saveXML();
    }

    public function erroStringToXml(string $erro)
    {
        $dom = new \DOMDocument('1.0', 'UTF-8');

        $mensagemDeErroValue = $dom->createTextNode($erro);
        $mensagemDeErroNode = $dom->createElement("mensagemDeErro");
        $mensagemDeErroNode->appendChild($mensagemDeErroValue);
        $erroNode = $dom->createElement('erro');
        $erroNode->appendChild($mensagemDeErroNode);

        $retornoNode = $dom->createElement('retorno');
        $retornoNode->appendChild($erroNode);

        $dom->appendChild($retornoNode);

        return $dom->saveXML();
    }

    /**
     * Responsável pelo formatação da mensagem de xml inválido, que será retornada ao usuário.
     * @return string
     */
    public function xmlInvalido() : string
    {
        $dom = new \DOMDocument('1.0', 'UTF-8');

        $mensagemValue = $dom->createTextNode('O documento enviado não é um arquivo xml válido.');
        $mensagemNode = $dom->createElement('mensagem');
        $mensagemNode->appendChild($mensagemValue);

        $retornoNode = $dom->createElement('retorno');

        $retornoNode->appendChild($mensagemNode);

        $dom->appendChild($retornoNode);

        return $dom->saveXML();
    }

    /**
     * @param \DOMDocument $dom
     * @param array $notas
     * @param $mensagemNode
     * @return \DOMElement|false
     */
    private function criarNodesParaVariasNotas(\DOMDocument $dom, array $notas, $mensagemNode)
    {
        $notasValidadasNode = $dom->createElement('Notas');

        foreach ($notas as $nota => $value) {

            $notaNode = $dom->createElement('Nota');

            $numeroDaNotaValue = $dom->createTextNode($value['numero']);
            $numeroDaNotaNode = $dom->createElement('NumeroNota');
            $numeroDaNotaNode->appendChild($numeroDaNotaValue);

            $codigoDeValidacaoDaNotaValue = $dom->createTextNode($value['codigo_verificacao']);
            $codigoDeValidacaoDaNotaNode = $dom->createElement('CodigoValidacao');
            $codigoDeValidacaoDaNotaNode->appendChild($codigoDeValidacaoDaNotaValue);

            $notaNode->appendChild($numeroDaNotaNode);
            $notaNode->appendChild($codigoDeValidacaoDaNotaNode);

            $notasValidadasNode->appendChild($notaNode);
        }

        $retornoNode = $dom->createElement('Retorno');
        $retornoNode->appendChild($mensagemNode);
        $retornoNode->appendChild($notasValidadasNode);

        return $retornoNode;
    }

    /**
     * @param \DOMDocument $dom
     * @param array $notas
     * @param $mensagemNode
     * @return \DOMElement|false
     */
    private function criarNodeParaUmaUnicaNota(\DOMDocument $dom, array $notas, $mensagemNode)
    {
        foreach ($notas as $nota => $value) {
            $numeroDaNotaValue = $dom->createTextNode($value['numero']);
            $numeroDaNotaNode = $dom->createElement('NumeroNota');
            $numeroDaNotaNode->appendChild($numeroDaNotaValue);

            $codigoDeValidacaoDaNotaValue = $dom->createTextNode($value['codigo_verificacao']);
            $codigoDeValidacaoDaNotaNode = $dom->createElement('CodigoValidacao');
            $codigoDeValidacaoDaNotaNode->appendChild($codigoDeValidacaoDaNotaValue);
        }

        $retornoNode = $dom->createElement('Retorno');
        $retornoNode->appendChild($mensagemNode);
        $retornoNode->appendChild($numeroDaNotaNode);
        $retornoNode->appendChild($codigoDeValidacaoDaNotaNode);

        return $retornoNode;
    }
}
