<?php

namespace App\Services\Tomador;

use App\Models\Cidade;
use PHPUnit\Util\Exception;

class BuscaCidade
{
    public static function peloCodigo(string $codigo)
    {
        $cidade = Cidade::where('codigo', $codigo)->first();

        if (!$cidade)
            throw new Exception("O Código informado não corresponde a nenhuma cidade cadastrada no banco de dados.");

        return $cidade;
    }

    /**
     * @param int $id
     * @return Cidade
     */
    public static function peloId(int $id) : Cidade
    {
        $cidade = Cidade::find($id);

        if (!$cidade)
            throw new Exception("O Id informado não corresponde a nenhuma cidade cadastrada no banco de dados.");

        return $cidade;
    }
}
