<?php

namespace App\Services\Prestador;

use App\Models\PrestadorNotaFiscal;
use PHPUnit\Exception;

class CriaPrestadorNotaFiscal
{
    private string $razao_nome_prestador;
    private string $cep_prestador;
    private string $cidade_prestador;
    private string $bairro_prestador;
    private string $rua_prestador;
    private string $numero_prestador;
    private string $complemento_prestador;
    private string $email_prestador;
    private string $telefone_prestador;
    private string $ramal_prestador;
    private int $tipo_pessoa_prestador;

    public function __construct(
        $razao_nome_prestador,
        $cep_prestador,
        $cidade_prestador,
        $bairro_prestador,
        $rua_prestador,
        $numero_prestador,
        $complemento_prestador,
        $email_prestador,
        $telefone_prestador,
        $ramal_prestador,
        $tipo_pessoa_prestador
    )
    {
        $this->razao_nome_prestador = $razao_nome_prestador;
        $this->cep_prestador = $cep_prestador;
        $this->cidade_prestador = $cidade_prestador;
        $this->bairro_prestador = $bairro_prestador;
        $this->rua_prestador = $rua_prestador;
        $this->numero_prestador = $numero_prestador;
        $this->complemento_prestador = $complemento_prestador;
        $this->email_prestador = $email_prestador;
        $this->telefone_prestador = $telefone_prestador;
        $this->ramal_prestador = $ramal_prestador;
        $this->tipo_pessoa_prestador = $tipo_pessoa_prestador;
    }

    /**
     * @throws \Exception
     */
    public function criar() : PrestadorNotaFiscal
    {
        try {
            return PrestadorNotaFiscal::create([
                'razao_nome_prestador' => $this->razao_nome_prestador,
                'cep_prestador' => $this->cep_prestador,
                'cidade_prestador' => $this->cidade_prestador,
                'bairro_prestador' => $this->bairro_prestador,
                'rua_prestador' => $this->rua_prestador,
                'numero_prestador' => $this->numero_prestador,
                'complemento_prestador' => $this->complemento_prestador,
                'email_prestador' => $this->email_prestador,
                'telefone_prestador' => $this->telefone_prestador,
                'ramal_prestador' => $this->ramal_prestador,
                'tipo_pessoa_prestador' => $this->tipo_pessoa_prestador,
            ]);

        }catch (Exception $exception) {
            throw new \Exception($exception->getMessage() . ' - Linha: ' . $exception->getLine());
        }
    }
}
