<?php

namespace App\Services\Notas;

use App\Enums\SituacaoEnum;
use App\Models\Cidade;
use App\Models\Instituicao;
use App\Models\Lote;
use App\Services\AtividadeEconomica\BuscaAtividadeEconomica;
use App\Services\Prestador\BuscaPrestador;
use App\Services\Prestador\BuscaPrestadorNotaFiscal;
use App\Services\Tomador\BuscaCidade;
use App\Services\Tomador\BuscaCriaTomador;
use App\Validadores\Rps\ValidadorRps;

class CriadorNotaFiscalServico
{
    private Lote $lote;

    private array $notasCriadas;

    public function __construct(Lote $lote)
    {
        $this->lote = $lote;
        $this->notasCriadas = [];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public function criar(): array
    {
        try {

            $instituicao = Instituicao::with('cidade')
                ->where('id', $this->lote->instituicao_id)
                ->first();

            $prestador = BuscaPrestador::buscar($this->lote, $instituicao->cidade->codigo);
            $prestador_id = $prestador->id;

            foreach ($this->lote->rps as $rps) {

                $nota = [];

                $numero_nota = BuscaNumeroDaNota::buscarOuGerarSeNaoExistir($prestador_id);
                $nota['numero'] = $numero_nota;

                $nota['codigo_verificacao'] = FormataCodigoDeVerificacaoNota::get($prestador_id, $numero_nota);

                $nota['descricao'] = $rps->discriminacao;
                $nota['numero_substituicao'] = null;
                $nota['numero_processo'] = null;
                $nota['situacao'] = SituacaoEnum::REGULAR;
                $nota['data_emissao'] = $rps->data_emissao;

                $nota['competencia'] = (new FormataCompetencia($rps->competencia))->anoMesDia();
                $nota['competencia_mes'] = (new FormataCompetencia($rps->competencia))->mes();
                $nota['competencia_ano'] = (new FormataCompetencia($rps->competencia))->ano();

                $nota['valor'] = (float) $rps->valor_servicos;
                $nota['valor_iss'] = (float) $rps->valor_iss;
                $nota['valor_inss'] = (float) $rps->valor_inss;
                $nota['base_calculo'] = (float) $rps->valor_servicos;
                $nota['valor_liquido'] = (float) $rps->valor_servicos - ($rps->valor_iss + $rps->valor_inss);
                $nota['deducao_legal'] = (float) $rps->valor_deducoes;
                $nota['valor_pis'] = (float) $rps->valor_pis;
                $nota['valor_irrf'] = (float) $rps->valor_ir;
                $nota['valor_confins'] = (float) $rps->valor_cofins;
                $nota['valor_csll'] = (float) $rps->valor_csll;
                $nota['outras_retencoes'] = (float) $rps->outras_retencoes;
                $nota['aliquota'] = (float) $rps->aliquota;
                $nota['data_cancelamento'] = null;
                $nota['exigibilidade_iss'] = 1;
//                $nota['retencao_iss'] = (float) $rps->valor_iss_retido;
                $nota['retencao_iss'] = (float) $rps->retencao_iss;

                //$nota['regime_tributacao_prestador'] = $rps->regime_especial_tributacao;
                $nota['regime_tributacao_prestador'] = $prestador->regime_tributacao;
                $nota['optante_simples_prestador'] = $rps->optante_simples_nacional == 1;
                $nota['desconto_condicionado'] = $rps->desconto_condicionado;
                $nota['desconto_incondicionado'] = $rps->desconto_incondicionado;
                $nota['pais_incidencia'] = 1058; // Brasil Cod

                //IDs
                $nota['id_prestador'] = $prestador_id;

                $tomador = (new BuscaCriaTomador())->buscar(
                    $rps,
                    $prestador_id,
                    $this->lote->instituicao_id
                );

                $nota['id_tomador'] = $tomador['tomador']->id;
                $nota['id_tomador_nota'] = $tomador['tomadorNotaServico']->id;

                $prestadorNotaFiscal = BuscaPrestadorNotaFiscal::buscarOuCriarSeNaoExistir($prestador_id);

                $nota['id_prestador_nota'] = $prestadorNotaFiscal->id;

                $atividade = BuscaAtividadeEconomica::buscar(
                    $rps->codigo_cnae,
                    $prestador_id
                );

                $nota['id_atividade'] = $atividade->id;
                $nota['id_instituicao'] = $this->lote->instituicao_id;

                $cidade_prestacao = BuscaCidade::peloCodigo($rps->codigo_municipio);
                $cidade_incidencia = BuscaCidade::peloCodigo($rps->codigo_municipal_tomador);
                $nota['id_cidade_prestacao'] = $cidade_prestacao->id;
                $nota['id_cidade_incidencia'] = $cidade_incidencia->id;

                $nota['id_dam'] = null;
                $nota['id_dam_avulso_externo'] = null;

                $notaCriada = NotaPersist::store($nota);

                array_push($this->notasCriadas, $notaCriada);

                IncrementaNumeroNota::incrementar($prestador_id);

                CriaRelacionamentoLoteRpsNota::criar(
                    $this->lote->id,
                    $rps->id,
                    $notaCriada->id
                );
            }

            return $this->notasCriadas;

        } catch (\Exception $exception) {
            throw new \Exception($exception->getMessage());
        }
    }
}
