<?php

namespace App\Services\AtividadeEconomica;

use App\Models\AtividadeEconomica;
use App\Models\AtividadeEconomicaClasse;
use App\Models\AtividadeEconomicaSubClasse;
use Exception;

class BuscaAtividadeEconomica
{
    /**
     * Responsável por buscar a atividade econômica informada pelo prestador.
     *
     * @param string $codigoCnae
     * @param int $prestadorId
     * @return AtividadeEconomica
     * @throws Exception
     */
    public static function buscar(string $codigoCnae, int $prestadorId) : AtividadeEconomica
    {
        try {

            $codCnaeFormatado = FormatadorCodigoCnae::formatar($codigoCnae);

            $atividadeSubClasse = AtividadeEconomicaSubClasse::where('subclasse', $codCnaeFormatado)->first();

            if (!$atividadeSubClasse)
                throw new Exception(" A Atividade Econômica Subclasse CNAE {$codCnaeFormatado} não foi localizada.");

            $atividade = AtividadeEconomica::where('id_prestador', $prestadorId)
                ->where('id_atividade_economica_subclasse', $atividadeSubClasse->id)
                ->first();

            if (!$atividade)
                throw new Exception(" Atividade Econômica não está cadastrada para este Prestador.");

            return $atividade;

        } catch (Exception $exception) {
            throw new Exception("Erro ao tentar encontrar a Atividade Econômica:" . $exception->getMessage());
        }
    }
}
