<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Usuario extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'nome',
        'cpf_cnpj',
        'login',
        'senha',
        'email',
        'situacao',
        'datainclusao',
        'logininclusao',
        'data_ultimo_acesso',
        'data_alteracao',

        'id_instituicao',
        'id_grupo',
    ];

    public function instituicao()
    {
        return $this->belongsTo(Instituicao::class, 'id_instituicao');
    }
}
