<?php

namespace App\Models;

use App\Models\InstituicaoFinanceira\BalancetePrestador;
use App\Models\InstituicaoFinanceira\LancamentosFinanceiro;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Prestador extends Model
{
    use HasFactory;

    protected $table = "prestador";

    protected $fillable = [
        'assinatura_digital',
        'data_solicitacao',
        'data_liberacao',
        'protocolo',
        'regime_tributacao',
        'optante_simples',
        'nome_representante',
        'cpf_representante',
        'logomarca',
        'situacao',
        'data_alteracao',

        'id_instituicao',
        'id_usuario',
        'id_dados_cadastrais',
        'id_contador',
    ];

    public function dadosCadastrais()
    {
        return $this->belongsTo(DadosCadastrais::class, 'id_dados_cadastrais');
    }

    public function instituicao()
    {
        return $this->belongsTo(Instituicao::class, 'id_instituicao');
    }

    public function notasServico()
    {
        return $this->hasMany(NotaFiscalServico::class);
    }

    public function lancamentos() : HasMany
    {
        return $this->hasMany(LancamentosFinanceiro::class);
    }


    public function balancetes() : HasMany
    {
        return $this->hasMany(BalancetePrestador::class);
    }
}
