<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AtividadeEconomicaSubClasse extends Model
{
    use HasFactory;

    protected $table = "atividade_economica_subclasse";

    public $timestamps = false;

    protected $fillable = [
        'subclasse',
        'nome_subclasse',
        'classe',
        'nome_classe',
        'grupo',
        'nome_grupo',
        'divisao',
        'nome_divisao'
    ];

    public function atividades()
    {
        return $this->hasMany(AtividadeEconomica::class);
    }
}
