<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AtividadeEconomica extends Model
{
    use HasFactory;

    protected $table = "atividade_economica";

    public $timestamps = false;

    protected $fillable = [
        'tipo',
        'situacao',

        'id_prestador',
        'id_atividade_economica_classe',
        'id_atividade_economica_subclasse',
    ];

    public function notasServico()
    {
        return $this->hasMany(NotaFiscalServico::class);
    }

    public function prestador()
    {
        return $this->belongsTo(Prestador::class, 'id_atividade_economica_subclasse');
    }

    public function atividadeClasse()
    {
        return $this->belongsTo(AtividadeEconomicaClasse::class, 'id_atividade_economica_classe');
    }

    public function atividadeSubClasse()
    {
        return $this->belongsTo(AtividadeEconomicaSubClasse::class, 'id_atividade_economica_subclasse');
    }
}
