<?php

namespace App\Http\Livewire\BalanceteFinanceiro;

use App\Models\InstituicaoFinanceira\BalancetePrestador;
use Livewire\Component;

class DetalhesBalanceteModal extends Component
{
    public $balancete;

    protected $listeners = ['exibirDetalhesDoBalanceteModal'];

    public function render()
    {
        return view('livewire.balancete-financeiro.detalhes-balancete-modal');
    }

    public function exibirDetalhesDoBalanceteModal(string $uuid)
    {
        $this->balancete = BalancetePrestador::with('lancamentos')
            ->where('uuid', $uuid)
            ->first();
    }
}
