<?php

if (!function_exists('dataPtBrToMysql')) {
    function dataPtBrToMysql($data)
    {
        if (!is_null($data)) {
            return implode('-', array_reverse(explode('/', $data)));
        }

        return null;
    }
}

if (!function_exists('realToMysql')) {
    function realToMysql($valor)
    {
        $source = array('.', ',');
        $replace = array('', '.');
        $valor = str_replace($source, $replace, $valor); //remove os pontos e substitui a virgula pelo ponto

        return $valor; //retorna o valor formatado para gravar no banco
    }
}

if (!function_exists('mysqlToReal')) {
    function mysqlToReal($valor)
    {
        return number_format($valor, 2, ',', '.');
    }
}

if (!function_exists('limpaFormatacaoCnpjCpf')) {
    function limpaFormatacaoCnpjCpf($cnpjCpf): array|string
    {
        $formatadores = ["-", "/", "."];

        return str_replace($formatadores, "", $cnpjCpf);
    }
}

if (!function_exists('ajustaValorParaDBImportExcel')) {
    function ajustaValorParaDBImportExcel($valor)
    {
        return str_replace(",", "", $valor);
    }
}

if (!function_exists('realToDatabase')) {
    function realToDatabase($valor): array|string
    {
        $source = array('.', ',');
        $replace = array('', '.');
        $valor = str_replace($source, $replace, $valor); //remove os pontos e substitui a virgula pelo ponto

        return $valor; //retorna o valor formatado para gravar no banco
    }
}

if (!function_exists('databaseToReal')) {
    function databaseToReal($valor): string
    {
        return number_format($valor, 2, '.', ',');
    }
}

/**
 * ---------------------------------------------------------------------
 *
 * Tenants Helpers
 *
 * ---------------------------------------------------------------------
 */


/**
 * Verifica se existe uma chave 'prestador_id' na sessão
 * e se esta chave não é null.
 * Se o teste passar, return true, senão, return false;
 */
if (!function_exists('existsInSessionPrestadorTenantId')) {
    function existsInSessionPrestadorTenantId(): bool
    {
        return session()->has('prestador_id') && !is_null(session('prestador_id'));
    }
}

